/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_plugin_h
#define _vdkb_plugin_h
#include <vdk/vdk.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>
#include <gmodule.h>
#include <vdkb2/vdkb_interface.h>


 /*
returns a pointer to an interface
users should override it in subclasses
*/
extern "C" VDKBAbstractComponentInterface* GetExportClass();


//=============== PLUGINS ========================
/*
this class is an interface with a component
contained into a shared library
*/
class VDKBPlugin
{
 protected:
  GModule *module; /*
		     assigned during construction
		     if NULL module is invalid
		   */
  VDKString lib_path,lib_name;
  VDKString module_name; //assigned during construction
  const char** icon; // assigned during construction (from module)
  VDKString  tip; // assigned during construction
  VDKString error;
  // assigned during construction (from module)
  VDKBAbstractComponentInterface* interface;
  int id; /*
	     assigned during construction
	     and = PLUGIN_TOOL_BEGIN + ordinal number
	  */
 public:
  VDKBPlugin(char* libpath, char* libname);

  ~VDKBPlugin();

  VDKBAbstractComponentInterface* Interface()
    { return interface; }
  bool DlOpen();
  bool DlClose();
  bool IsValid() { return module != (GModule*) NULL; }

  int  Id() { return id; }
  void Id(int id) { VDKBPlugin::id = id; }

  const char** Icon() { return icon; }

  char* Tip() { return tip; }

  char* Error() { return (char*) error; }

  char* ModuleName() { return (char*) module_name; }
  char* LibName() { return (char*) lib_name; }
  char* PathName() { return (char*) lib_path; }
  void	LibName(char* p) { lib_name = p; }
  void	PathName(char* p) { lib_path = p; }
};

//=============== PLUGIN LIST ======================

typedef VDKValueList<VDKBPlugin> VDKBPlugs;
typedef VDKValueListIterator<VDKBPlugin> VDKBPluginListIterator;


class VDKBPluginList : public VDKBPlugs
{
 public:
  VDKBPluginList() {}
  ~VDKBPluginList() {}
  bool Load(char* file);
  bool Save(char* file);
  bool DlOpen();
  bool DlClose();
  // returns the interface of the loaded
  // <id> plugin or
  // looking at <classname> interface vdk class name
  // NULL on failure
  VDKBAbstractComponentInterface* Interface(int id);
  VDKBAbstractComponentInterface* Interface(char *classname);
};

#endif

