/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed May 27 18:50:23 2015

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_33 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 6676, "epsg", 6676,
        "JGD2011 / Japan Plane Rectangular CS VIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS VIII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",138.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",0],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"667");
    add_srs_wkt (p, 13,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 6677, "epsg", 6677,
        "JGD2011 / Japan Plane Rectangular CS IX", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS IX\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",36],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",139.8333333333333],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"6677\"]]");
    p = add_epsg_def_ex (filter, first, last, 6678, "epsg", 6678,
        "JGD2011 / Japan Plane Rectangular CS X", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS X\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",40],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",140.8333333333333],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"6678\"]]");
    p = add_epsg_def_ex (filter, first, last, 6679, "epsg", 6679,
        "JGD2011 / Japan Plane Rectangular CS XI", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XI\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",44],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",140.25],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",0],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6679\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6680, "epsg", 6680,
        "JGD2011 / Japan Plane Rectangular CS XII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",142.25],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",0],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"668");
    add_srs_wkt (p, 13,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 6681, "epsg", 6681,
        "JGD2011 / Japan Plane Rectangular CS XIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",144.25],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 13,
        "81\"]]");
    p = add_epsg_def_ex (filter, first, last, 6682, "epsg", 6682,
        "JGD2011 / Japan Plane Rectangular CS XIV", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIV\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",142],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",0],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6682\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6683, "epsg", 6683,
        "JGD2011 / Japan Plane Rectangular CS XV", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XV\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",26],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",127.5],PARAMETER[\"scale_factor\",0.9999],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",0],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6683\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6684, "epsg", 6684,
        "JGD2011 / Japan Plane Rectangular CS XVI", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVI\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",124],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",0],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6684\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6685, "epsg", 6685,
        "JGD2011 / Japan Plane Rectangular CS XVII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",131],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6685\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6686, "epsg", 6686,
        "JGD2011 / Japan Plane Rectangular CS XVIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVIII\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",20],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",136],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6686\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6687, "epsg", 6687,
        "JGD2011 / Japan Plane Rectangular CS XIX", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIX\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",154],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",0],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6687\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6688, "epsg", 6688,
        "JGD2011 / UTM zone 51N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 51N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6668\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",123],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6688\"]]");
    p = add_epsg_def_ex (filter, first, last, 6689, "epsg", 6689,
        "JGD2011 / UTM zone 52N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 52N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6668\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",129],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6689\"]]");
    p = add_epsg_def_ex (filter, first, last, 6690, "epsg", 6690,
        "JGD2011 / UTM zone 53N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 53N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6668\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",135],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6690\"]]");
    p = add_epsg_def_ex (filter, first, last, 6691, "epsg", 6691,
        "JGD2011 / UTM zone 54N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 54N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6668\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",141],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6691\"]]");
    p = add_epsg_def_ex (filter, first, last, 6692, "epsg", 6692,
        "JGD2011 / UTM zone 55N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 55N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6668\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",147],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6692\"]]");
    p = add_epsg_def_ex (filter, first, last, 6696, "epsg", 6696,
        "JGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"JGD2000 + JGD2000 (vertical) height\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4612\"]],VERT_CS[\"JGD2000");
    add_srs_wkt (p, 8,
        " (vertical) height\",VERT_DATUM[\"Japanese Geodetic Datu");
    add_srs_wkt (p, 9,
        "m 2000 (vertical)\",2005,AUTHORITY[\"EPSG\",\"1130\"]],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\"");
    add_srs_wkt (p, 11,
        ",UP],AUTHORITY[\"EPSG\",\"6694\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "6696\"]]");
    p = add_epsg_def_ex (filter, first, last, 6697, "epsg", 6697,
        "JGD2011", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"JGD2011 + JGD2011 (vertical) height\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"6668\"]],VERT_CS[\"JGD2011 (vertical) height\",VE");
    add_srs_wkt (p, 8,
        "RT_DATUM[\"Japanese Geodetic Datum 2011 (vertical)\",200");
    add_srs_wkt (p, 9,
        "5,AUTHORITY[\"EPSG\",\"1131\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 10,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"6695\"]],AUTHORITY[\"EPSG\",\"6697\"]]");
    p = add_epsg_def_ex (filter, first, last, 6700, "epsg", 6700,
        "Tokyo", 1, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-146.414,507.337,68");
    add_proj4text (p, 1,
        "0.507,0,0,0,0 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Tokyo + JSLD72 height\",GEOGCS[\"Tokyo\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397.155,299.152");
    add_srs_wkt (p, 2,
        "8128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-146.414,507.");
    add_srs_wkt (p, 3,
        "337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"6301\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4301\"]],VERT_CS[\"JSLD72 height\",VERT_");
    add_srs_wkt (p, 8,
        "DATUM[\"Japanese Standard Levelling Datum 1972\",2005,AU");
    add_srs_wkt (p, 9,
        "THORITY[\"EPSG\",\"1129\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 11,
        "693\"]],AUTHORITY[\"EPSG\",\"6700\"]]");
    p = add_epsg_def_ex (filter, first, last, 6703, "epsg", 6703,
        "WGS 84 / TM 60 SW", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-60 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=10000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM 60 SW\",GEOGCS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-60],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"6703\"]]");
    p = add_epsg_def_ex (filter, first, last, 6706, "epsg", 6706,
        "RDN2008", 1, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RDN2008\",DATUM[\"Rete_Dinamica_Nazionale_2008\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1132\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"6706\"]]");
    p = add_epsg_def_ex (filter, first, last, 6707, "epsg", 6707,
        "RDN2008 / TM32", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / TM32\",GEOGCS[\"RDN2008\",DATUM[\"Ret");
    add_srs_wkt (p, 1,
        "e_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6706\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6707\"]]");
    p = add_epsg_def_ex (filter, first, last, 6708, "epsg", 6708,
        "RDN2008 / TM33", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / TM33\",GEOGCS[\"RDN2008\",DATUM[\"Ret");
    add_srs_wkt (p, 1,
        "e_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6706\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",15],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6708\"]]");
    p = add_epsg_def_ex (filter, first, last, 6709, "epsg", 6709,
        "RDN2008 / TM34", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / TM34\",GEOGCS[\"RDN2008\",DATUM[\"Ret");
    add_srs_wkt (p, 1,
        "e_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6706\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",21],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6709\"]]");
    p = add_epsg_def_ex (filter, first, last, 6720, "epsg", 6720,
        "WGS 84 / CIG92", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105.625 +k=1.000024 +x_0=500");
    add_proj4text (p, 1,
        "00 +y_0=1300000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / CIG92\",GEOGCS[\"WGS 84\",DATUM[\"WGS_");
    add_srs_wkt (p, 1,
        "1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",105.625],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 9,
        "00024],PARAMETER[\"false_easting\",50000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",1300000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"6720\"]]");
    p = add_epsg_def_ex (filter, first, last, 6721, "epsg", 6721,
        "GDA94 / CIG94", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105.625 +k=1.00002514 +x_0=5");
    add_proj4text (p, 1,
        "0000 +y_0=1300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / CIG94\",GEOGCS[\"GDA94\",DATUM[\"Geocen");
    add_srs_wkt (p, 1,
        "tric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",105.625],PARAMETER[\"scale_factor\",1.0000251");
    add_srs_wkt (p, 10,
        "4],PARAMETER[\"false_easting\",50000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",1300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"6721\"]]");
    p = add_epsg_def_ex (filter, first, last, 6722, "epsg", 6722,
        "WGS 84 / CKIG92", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96.875 +k=1 +x_0=50000 +y_0=");
    add_proj4text (p, 1,
        "1400000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / CKIG92\",GEOGCS[\"WGS 84\",DATUM[\"WGS");
    add_srs_wkt (p, 1,
        "_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",96.875],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",50000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",1400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"6722\"]]");
    p = add_epsg_def_ex (filter, first, last, 6723, "epsg", 6723,
        "GDA94 / CKIG94", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96.875 +k=0.99999387 +x_0=50");
    add_proj4text (p, 1,
        "000 +y_0=1500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / CKIG94\",GEOGCS[\"GDA94\",DATUM[\"Geoce");
    add_srs_wkt (p, 1,
        "ntric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",96.875],PARAMETER[\"scale_factor\",0.9999938");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"false_easting\",50000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"6723\"]]");
    p = add_epsg_def_ex (filter, first, last, 6732, "epsg", 6732,
        "GDA94 / MGA zone 41", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 41\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",63],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"6732\"]]");
    p = add_epsg_def_ex (filter, first, last, 6733, "epsg", 6733,
        "GDA94 / MGA zone 42", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 42\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",69],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"6733\"]]");
    p = add_epsg_def_ex (filter, first, last, 6734, "epsg", 6734,
        "GDA94 / MGA zone 43", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 43\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",75],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"6734\"]]");
    p = add_epsg_def_ex (filter, first, last, 6735, "epsg", 6735,
        "GDA94 / MGA zone 44", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 44\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",81],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"6735\"]]");
    p = add_epsg_def_ex (filter, first, last, 6736, "epsg", 6736,
        "GDA94 / MGA zone 46", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 46\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",93],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"6736\"]]");
    p = add_epsg_def_ex (filter, first, last, 6737, "epsg", 6737,
        "GDA94 / MGA zone 47", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 47\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",99],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"6737\"]]");
    p = add_epsg_def_ex (filter, first, last, 6738, "epsg", 6738,
        "GDA94 / MGA zone 59", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 59\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",171],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"6738\"]]");
    p = add_epsg_def_ex (filter, first, last, 6783, "epsg", 6783,
        "NAD83(CORS96)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Oper");
    add_srs_wkt (p, 1,
        "ating_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]]");
    p = add_epsg_def_ex (filter, first, last, 6867, "epsg", 6867,
        "NAD83(CORS96) / Oregon LCC (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120");
    add_proj4text (p, 1,
        ".5 +x_0=400000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon LCC (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(CORS96)\",DATUM[\"NAD83_Continuously_Operating_Referenc");
    add_srs_wkt (p, 2,
        "e_Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 8,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_1\",43],PARAMETER[\"standard_parallel_2\",45.5],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"latitude_of_origin\",41.75],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-120.5],PARAMETER[\"false_easting\",400000],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"6867\"]]");
    p = add_epsg_def_ex (filter, first, last, 6868, "epsg", 6868,
        "NAD83(CORS96) / Oregon GIC Lambert (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120");
    add_proj4text (p, 1,
        ".5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +units=ft +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon GIC Lambert (ft)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating");
    add_srs_wkt (p, 2,
        "_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",43],PARAMETER[\"standard_parallel_2\",45.5");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",41.75],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",-120.5],PARAMETER[\"false_easting\",131");
    add_srs_wkt (p, 12,
        "2335.958],PARAMETER[\"false_northing\",0],UNIT[\"foot\",");
    add_srs_wkt (p, 13,
        "0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6868\"]]");
    p = add_epsg_def_ex (filter, first, last, 6870, "epsg", 6870,
        "ETRS89 / Albania 2010", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Albania 2010\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",20],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"6870\"]]");
    p = add_epsg_def_ex (filter, first, last, 6871, "epsg", 6871,
        "WGS 84 / Pseudo-Mercator", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +uni");
    add_proj4text (p, 1,
        "ts=m +geoidgrids=egm08_25.gtx +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"WGS 84 / Pseudo-Mercator +  EGM2008 geoid hei");
    add_srs_wkt (p, 1,
        "ght\",PROJCS[\"WGS 84 / Pseudo-Mercator\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 2,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"M");
    add_srs_wkt (p, 8,
        "ercator_1SP\"],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "EXTENSION[\"PROJ4\",\"+proj=merc +a=6378137 +b=6378137 +");
    add_srs_wkt (p, 13,
        "lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +n");
    add_srs_wkt (p, 14,
        "adgrids=@null +wktext  +no_defs\"],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "3857\"]],VERT_CS[\"EGM2008 geoid height\",VERT_DATUM[\"E");
    add_srs_wkt (p, 16,
        "GM2008 geoid\",2005,EXTENSION[\"PROJ4_GRIDS\",\"egm08_25");
    add_srs_wkt (p, 17,
        ".gtx\"],AUTHORITY[\"EPSG\",\"1027\"]],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 19,
        "EPSG\",\"3855\"]],AUTHORITY[\"EPSG\",\"6871\"]]");
    p = add_epsg_def_ex (filter, first, last, 6875, "epsg", 6875,
        "RDN2008 / Italy zone", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9985000000000001 +x_");
    add_proj4text (p, 1,
        "0=7000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / Italy zone\",GEOGCS[\"RDN2008\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",12],PARAMETER[\"scale_factor\",0.9985],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",7000000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"6875\"]]");
    p = add_epsg_def_ex (filter, first, last, 6876, "epsg", 6876,
        "RDN2008 / Zone 12", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=3000000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / Zone 12\",GEOGCS[\"RDN2008\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",3000000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"6876\"]]");
    p = add_epsg_def_ex (filter, first, last, 6879, "epsg", 6879,
        "NAD83(2011) / Wisconsin Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wisconsin Central\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",45.");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"standard_parallel_2\",44.25],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",43.83333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-90],PARAMETER[\"false_easting\",600000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"6879\"]]");
    p = add_epsg_def_ex (filter, first, last, 6880, "epsg", 6880,
        "NAD83(2011) / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Nebraska (ftUS)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
        "mal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",43],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",40],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",39.83333333333334],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-100],PARAMETER[\"false_easting\",1640416.6667],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6880\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6884, "epsg", 6884,
        "NAD83(CORS96) / Oregon North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon North\",GEOGCS[\"NAD83(C");
    add_srs_wkt (p, 1,
        "ORS96)\",DATUM[\"NAD83_Continuously_Operating_Reference_");
    add_srs_wkt (p, 2,
        "Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "33\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 8,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",46],PARAMETER[\"standard_parallel_2\",44.33333333333334");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",43.66666666666666],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-120.5],PARAMETER[\"false_e");
    add_srs_wkt (p, 12,
        "asting\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6884\"]]");
    p = add_epsg_def_ex (filter, first, last, 6885, "epsg", 6885,
        "NAD83(CORS96) / Oregon North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon North (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_Refer");
    add_srs_wkt (p, 2,
        "ence_Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"L");
    add_srs_wkt (p, 8,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",46],PARAMETER[\"standard_parallel_2\",44.3333333");
    add_srs_wkt (p, 10,
        "3333334],PARAMETER[\"latitude_of_origin\",43.66666666666");
    add_srs_wkt (p, 11,
        "666],PARAMETER[\"central_meridian\",-120.5],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",8202099.738],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 15,
        "885\"]]");
    p = add_epsg_def_ex (filter, first, last, 6886, "epsg", 6886,
        "NAD83(CORS96) / Oregon South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon South\",GEOGCS[\"NAD83(C");
    add_srs_wkt (p, 1,
        "ORS96)\",DATUM[\"NAD83_Continuously_Operating_Reference_");
    add_srs_wkt (p, 2,
        "Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "33\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 8,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",44],PARAMETER[\"standard_parallel_2\",42.33333333333334");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",41.66666666666666],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-120.5],PARAMETER[\"false_e");
    add_srs_wkt (p, 12,
        "asting\",1500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6886\"]]");
    p = add_epsg_def_ex (filter, first, last, 6887, "epsg", 6887,
        "NAD83(CORS96) / Oregon South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon South (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_Refer");
    add_srs_wkt (p, 2,
        "ence_Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"L");
    add_srs_wkt (p, 8,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",44],PARAMETER[\"standard_parallel_2\",42.3333333");
    add_srs_wkt (p, 10,
        "3333334],PARAMETER[\"latitude_of_origin\",41.66666666666");
    add_srs_wkt (p, 11,
        "666],PARAMETER[\"central_meridian\",-120.5],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",4921259.843],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 15,
        "887\"]]");
    p = add_epsg_def_ex (filter, first, last, 7400, "epsg", 7400,
        "NTF (Paris)", 1, 1,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "none", "grad",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,");
    add_proj4text (p, 1,
        "320,0,0,0,0 +pm=paris +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) + NGF IGN69 height\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,32");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 5,
        ",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",");
    add_srs_wkt (p, 6,
        "0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4807\"]],VERT_CS[\"NGF-IGN69 height\",VERT_DATUM");
    add_srs_wkt (p, 9,
        "[\"Nivellement General de la France - IGN69\",2005,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"572");
    add_srs_wkt (p, 12,
        "0\"]],AUTHORITY[\"EPSG\",\"7400\"]]");
    p = add_epsg_def_ex (filter, first, last, 7401, "epsg", 7401,
        "NTF (Paris) / France II (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / France II + NGF Lallemand\",PRO");
    add_srs_wkt (p, 1,
        "JCS[\"NTF (Paris) / France II (deprecated)\",GEOGCS[\"NT");
    add_srs_wkt (p, 2,
        "F (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Par");
    add_srs_wkt (p, 3,
        "is\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021");
    add_srs_wkt (p, 4,
        "2936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,3");
    add_srs_wkt (p, 5,
        "20,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris");
    add_srs_wkt (p, 6,
        "\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\"");
    add_srs_wkt (p, 7,
        ",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[");
    add_srs_wkt (p, 8,
        "\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 9,
        "EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1");
    add_srs_wkt (p, 10,
        "SP\"],PARAMETER[\"latitude_of_origin\",52],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",0],PARAMETER[\"scale_factor\",0.999877");
    add_srs_wkt (p, 12,
        "42],PARAMETER[\"false_easting\",600000],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",2200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"27582\"]],VERT_CS[\"NGF Lallemand height\",V");
    add_srs_wkt (p, 16,
        "ERT_DATUM[\"Nivellement General de la France - Lallemand");
    add_srs_wkt (p, 17,
        "\",2005,AUTHORITY[\"EPSG\",\"5118\"]],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 19,
        "EPSG\",\"5719\"]],AUTHORITY[\"EPSG\",\"7401\"]]");
    p = add_epsg_def_ex (filter, first, last, 7402, "epsg", 7402,
        "NTF (Paris) / France II (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / France II + NGF IGN69\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"NTF (Paris) / France II (deprecated)\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 2,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 4,
        "269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0");
    add_srs_wkt (p, 5,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2");
    add_srs_wkt (p, 6,
        ".33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.");
    add_srs_wkt (p, 7,
        "01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"L");
    add_srs_wkt (p, 8,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 9,
        "SG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP");
    add_srs_wkt (p, 10,
        "\"],PARAMETER[\"latitude_of_origin\",52],PARAMETER[\"cen");
    add_srs_wkt (p, 11,
        "tral_meridian\",0],PARAMETER[\"scale_factor\",0.99987742");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_easting\",600000],PARAMETER[\"false_");
    add_srs_wkt (p, 13,
        "northing\",2200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"27582\"]],VERT_CS[\"NGF-IGN69 height\",VERT_D");
    add_srs_wkt (p, 16,
        "ATUM[\"Nivellement General de la France - IGN69\",2005,A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 18,
        "\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 19,
        "5720\"]],AUTHORITY[\"EPSG\",\"7402\"]]");
    p = add_epsg_def_ex (filter, first, last, 7403, "epsg", 7403,
        "NTF (Paris) / France III (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / France III + NGF IGN69\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"NTF (Paris) / France III (deprecated)\",GEOGCS[\"NTF ");
    add_srs_wkt (p, 2,
        "(Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris");
    add_srs_wkt (p, 3,
        "\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129");
    add_srs_wkt (p, 4,
        "36269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320");
    add_srs_wkt (p, 5,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 6,
        ",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",");
    add_srs_wkt (p, 7,
        "0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"");
    add_srs_wkt (p, 8,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 9,
        "PSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1S");
    add_srs_wkt (p, 10,
        "P\"],PARAMETER[\"latitude_of_origin\",49],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",0],PARAMETER[\"scale_factor\",0.9998774");
    add_srs_wkt (p, 12,
        "99],PARAMETER[\"false_easting\",600000],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",3200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"27583\"]],VERT_CS[\"NGF-IGN69 height\",VERT_");
    add_srs_wkt (p, 16,
        "DATUM[\"Nivellement General de la France - IGN69\",2005,");
    add_srs_wkt (p, 17,
        "AUTHORITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 18,
        "[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 19,
        "\"5720\"]],AUTHORITY[\"EPSG\",\"7403\"]]");
    p = add_epsg_def_ex (filter, first, last, 7404, "epsg", 7404,
        "RT90", 1, 1,
        "Bessel 1841", "Greenwich",
        "Rikets_koordinatsystem_1990", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=414.1,41.3,603.1,-0");
    add_proj4text (p, 1,
        ".855,2.141,-7.023,0 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"RT90 + RH70 height\",GEOGCS[\"RT90\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Rikets_koordinatsystem_1990\",SPHEROID[\"Bessel 1841\",6");
    add_srs_wkt (p, 2,
        "377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[414.1,41.3,603.1,-0.855,2.141,-7.023,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6124\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4124\"]],VERT_CS[");
    add_srs_wkt (p, 8,
        "\"RH70 height\",VERT_DATUM[\"Rikets hojdsystem 1970\",20");
    add_srs_wkt (p, 9,
        "05,AUTHORITY[\"EPSG\",\"5117\"]],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"5718\"]],AUTHORITY[\"EPSG\",\"7404\"]]");
    p = add_epsg_def_ex (filter, first, last, 7405, "epsg", 7405,
        "OSGB 1936 / British National Grid", 0, 0,
        "Airy 1830", "Greenwich",
        "OSGB_1936", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49 +lon_0=-2 +k=0.9996012717 +x_0=400");
    add_proj4text (p, 1,
        "000 +y_0=-100000 +ellps=airy +towgs84=446.448,-125.157,5");
    add_proj4text (p, 2,
        "42.06,0.15,0.247,0.842,-20.489 +units=m +vunits=m +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"OSGB 1936 / British National Grid + ODN heigh");
    add_srs_wkt (p, 1,
        "t\",PROJCS[\"OSGB 1936 / British National Grid\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"OSGB 1936\",DATUM[\"OSGB_1936\",SPHEROID[\"Airy 1830\"");
    add_srs_wkt (p, 3,
        ",6377563.396,299.3249646,AUTHORITY[\"EPSG\",\"7001\"]],T");
    add_srs_wkt (p, 4,
        "OWGS84[446.448,-125.157,542.06,0.15,0.247,0.842,-20.489]");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"6277\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 6,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 7,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 8,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4277");
    add_srs_wkt (p, 9,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",49],PARAMETER[\"central_meridian\",-2]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"scale_factor\",0.9996012717],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_easting\",400000],PARAMETER[\"false_northing\",-1000");
    add_srs_wkt (p, 13,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 14,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 15,
        "PSG\",\"27700\"]],VERT_CS[\"ODN height\",VERT_DATUM[\"Or");
    add_srs_wkt (p, 16,
        "dnance Datum Newlyn\",2005,AUTHORITY[\"EPSG\",\"5101\"]]");
    add_srs_wkt (p, 17,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"U");
    add_srs_wkt (p, 18,
        "p\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 19,
        ",\"7405\"]]");
    p = add_epsg_def_ex (filter, first, last, 7406, "epsg", 7406,
        "NAD27", 1, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=NAD27 +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD27 + NGVD29 height\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],VERT_CS[\"NGVD29 height\",VERT_DATUM[\"National G");
    add_srs_wkt (p, 8,
        "eodetic Vertical Datum 1929\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 9,
        "5102\"]],UNIT[\"US survey foot\",0.3048006096012192,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Up\",UP],AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"5702\"]],AUTHORITY[\"EPSG\",\"7406\"]]");
    p = add_epsg_def_ex (filter, first, last, 7407, "epsg", 7407,
        "NAD27 / Texas North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_2=36.18333333333333 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD27 / Texas North + NGVD29 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"NAD27 / Texas North\",GEOGCS[\"NAD27\",DATUM[\"North_A");
    add_srs_wkt (p, 2,
        "merican_Datum_1927\",SPHEROID[\"Clarke 1866\",6378206.4,");
    add_srs_wkt (p, 3,
        "294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",34.65],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",36.18333333333333],PARAMETER[\"latitude_of_origin\",34]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"central_meridian\",-101.5],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",2000000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 13,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"32037\"]],VERT_CS[\"NGVD29 height\",VERT_D");
    add_srs_wkt (p, 16,
        "ATUM[\"National Geodetic Vertical Datum 1929\",2005,AUTH");
    add_srs_wkt (p, 17,
        "ORITY[\"EPSG\",\"5102\"]],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 18,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Up\",U");
    add_srs_wkt (p, 19,
        "P],AUTHORITY[\"EPSG\",\"5702\"]],AUTHORITY[\"EPSG\",\"74");
    add_srs_wkt (p, 20,
        "07\"]]");
    p = add_epsg_def_ex (filter, first, last, 7408, "epsg", 7408,
        "Amersfoort", 1, 1,
        "Bessel 1841", "Greenwich",
        "Amersfoort", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=565.4171,50.3319,46");
    add_proj4text (p, 1,
        "5.5524,-0.398957388243134,0.343987817378283,-1.877401639");
    add_proj4text (p, 2,
        "98045,4.0725 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"RD/NAP\",GEOGCS[\"Amersfoort\",DATUM[\"Amersf");
    add_srs_wkt (p, 1,
        "oort\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[565.4171,50.3319,4");
    add_srs_wkt (p, 3,
        "65.5524,-0.398957388243134,0.343987817378283,-1.87740163");
    add_srs_wkt (p, 4,
        "998045,4.0725],AUTHORITY[\"EPSG\",\"6289\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4289\"]],VERT_CS[\"NAP height\",VERT_DATUM[\"Nor");
    add_srs_wkt (p, 9,
        "maal Amsterdams Peil\",2005,AUTHORITY[\"EPSG\",\"5109\"]");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Up\",UP],AUTHORITY[\"EPSG\",\"5709\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"7408\"]]");
    p = add_epsg_def_ex (filter, first, last, 7409, "epsg", 7409,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + EVRF2000 height\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],VERT_CS[\"EVRF");
    add_srs_wkt (p, 8,
        "2000 height\",VERT_DATUM[\"European Vertical Reference F");
    add_srs_wkt (p, 9,
        "rame 2000\",2005,AUTHORITY[\"EPSG\",\"5129\"]],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"5730\"]],AUTHORITY[\"EPSG\",\"7409\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7410, "epsg", 7410,
        "PSD93", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "PDO_Survey_Datum_1993", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-180.624,-225.516,1");
    add_proj4text (p, 1,
        "73.919,-0.81,-1.898,8.336,16.71006 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"PSHD93\",GEOGCS[\"PSD93\",DATUM[\"PDO_Survey_");
    add_srs_wkt (p, 1,
        "Datum_1993\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,");
    add_srs_wkt (p, 2,
        "293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-180.624,-");
    add_srs_wkt (p, 3,
        "225.516,173.919,-0.81,-1.898,8.336,16.71006],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6134\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4134\"]],VERT_CS[");
    add_srs_wkt (p, 8,
        "\"PHD93 height\",VERT_DATUM[\"PDO Height Datum 1993\",20");
    add_srs_wkt (p, 9,
        "05,AUTHORITY[\"EPSG\",\"5123\"]],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"5724\"]],AUTHORITY[\"EPSG\",\"7410\"]]");
    p = add_epsg_def_ex (filter, first, last, 7411, "epsg", 7411,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone II + NGF Lallemand");
    add_srs_wkt (p, 1,
        " height\",PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francai");
    add_srs_wkt (p, 3,
        "se_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.");
    add_srs_wkt (p, 4,
        "4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168");
    add_srs_wkt (p, 5,
        ",-60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"");
    add_srs_wkt (p, 6,
        "Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"");
    add_srs_wkt (p, 7,
        "grad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]]");
    add_srs_wkt (p, 8,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 9,
        "RITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_");
    add_srs_wkt (p, 10,
        "Conic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 12,
        ".99987742],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 13,
        "[\"false_northing\",2200000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"27572\"]],VERT_CS[\"NGF Lallemand he");
    add_srs_wkt (p, 16,
        "ight\",VERT_DATUM[\"Nivellement General de la France - L");
    add_srs_wkt (p, 17,
        "allemand\",2005,AUTHORITY[\"EPSG\",\"5118\"]],UNIT[\"met");
    add_srs_wkt (p, 18,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUT");
    add_srs_wkt (p, 19,
        "HORITY[\"EPSG\",\"5719\"]],AUTHORITY[\"EPSG\",\"7411\"]]");
    p = add_epsg_def_ex (filter, first, last, 7412, "epsg", 7412,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone II + NGF IGN69\",P");
    add_srs_wkt (p, 1,
        "ROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"NTF (Pa");
    add_srs_wkt (p, 2,
        "ris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129362");
    add_srs_wkt (p, 4,
        "69,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,");
    add_srs_wkt (p, 5,
        "0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.");
    add_srs_wkt (p, 6,
        "33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.0");
    add_srs_wkt (p, 7,
        "1570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"La");
    add_srs_wkt (p, 8,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 9,
        "G\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",52],PARAMETER[\"centr");
    add_srs_wkt (p, 11,
        "al_meridian\",0],PARAMETER[\"scale_factor\",0.99987742],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_easting\",600000],PARAMETER[\"false_no");
    add_srs_wkt (p, 13,
        "rthing\",2200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"27572\"]],VERT_CS[\"NGF Lallemand height\",VERT");
    add_srs_wkt (p, 16,
        "_DATUM[\"Nivellement General de la France - Lallemand\",");
    add_srs_wkt (p, 17,
        "2005,AUTHORITY[\"EPSG\",\"5118\"]],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EP");
    add_srs_wkt (p, 19,
        "SG\",\"5719\"]],AUTHORITY[\"EPSG\",\"7412\"]]");
    p = add_epsg_def_ex (filter, first, last, 7413, "epsg", 7413,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone III + NGF IGN69\",");
    add_srs_wkt (p, 1,
        "PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[\"NTF (");
    add_srs_wkt (p, 2,
        "Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 4,
        "269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0");
    add_srs_wkt (p, 5,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2");
    add_srs_wkt (p, 6,
        ".33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.");
    add_srs_wkt (p, 7,
        "01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"L");
    add_srs_wkt (p, 8,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 9,
        "SG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP");
    add_srs_wkt (p, 10,
        "\"],PARAMETER[\"latitude_of_origin\",49],PARAMETER[\"cen");
    add_srs_wkt (p, 11,
        "tral_meridian\",0],PARAMETER[\"scale_factor\",0.99987749");
    add_srs_wkt (p, 12,
        "9],PARAMETER[\"false_easting\",600000],PARAMETER[\"false");
    add_srs_wkt (p, 13,
        "_northing\",3200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"27573\"]],VERT_CS[\"NGF Lallemand height\",V");
    add_srs_wkt (p, 16,
        "ERT_DATUM[\"Nivellement General de la France - Lallemand");
    add_srs_wkt (p, 17,
        "\",2005,AUTHORITY[\"EPSG\",\"5118\"]],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 19,
        "EPSG\",\"5719\"]],AUTHORITY[\"EPSG\",\"7413\"]]");
    p = add_epsg_def_ex (filter, first, last, 7414, "epsg", 7414,
        "Tokyo", 1, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-146.414,507.337,68");
    add_proj4text (p, 1,
        "0.507,0,0,0,0 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Tokyo + JSLD69 height\",GEOGCS[\"Tokyo\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397.155,299.152");
    add_srs_wkt (p, 2,
        "8128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-146.414,507.");
    add_srs_wkt (p, 3,
        "337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"6301\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4301\"]],VERT_CS[\"JSLD69 height\",VERT_");
    add_srs_wkt (p, 8,
        "DATUM[\"Japanese Standard Levelling Datum 1969\",2005,AU");
    add_srs_wkt (p, 9,
        "THORITY[\"EPSG\",\"5122\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 11,
        "723\"]],AUTHORITY[\"EPSG\",\"7414\"]]");
    p = add_epsg_def_ex (filter, first, last, 7415, "epsg", 7415,
        "Amersfoort / RD New", 0, 0,
        "Bessel 1841", "Greenwich",
        "Amersfoort", "Oblique_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=52.15616055555555 +lon_0=5.387638888");
    add_proj4text (p, 1,
        "88889 +k=0.9999079 +x_0=155000 +y_0=463000 +ellps=bessel");
    add_proj4text (p, 2,
        " +towgs84=565.4171,50.3319,465.5524,-0.398957388243134,0");
    add_proj4text (p, 3,
        ".343987817378283,-1.87740163998045,4.0725 +units=m +vuni");
    add_proj4text (p, 4,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Amersfoort / RD New + NAP height\",PROJCS[\"A");
    add_srs_wkt (p, 1,
        "mersfoort / RD New\",GEOGCS[\"Amersfoort\",DATUM[\"Amers");
    add_srs_wkt (p, 2,
        "foort\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[565.4171,50.3319,");
    add_srs_wkt (p, 4,
        "465.5524,-0.398957388243134,0.343987817378283,-1.8774016");
    add_srs_wkt (p, 5,
        "3998045,4.0725],AUTHORITY[\"EPSG\",\"6289\"]],PRIMEM[\"G");
    add_srs_wkt (p, 6,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 8,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 9,
        "\"EPSG\",\"4289\"]],PROJECTION[\"Oblique_Stereographic\"");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",52.15616055555555],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",5.38763888888889],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"scale_factor\",0.9999079],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 13,
        ",155000],PARAMETER[\"false_northing\",463000],UNIT[\"met");
    add_srs_wkt (p, 14,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 15,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"28992\"]],VERT_CS[\"");
    add_srs_wkt (p, 16,
        "NAP height\",VERT_DATUM[\"Normaal Amsterdams Peil\",2005");
    add_srs_wkt (p, 17,
        ",AUTHORITY[\"EPSG\",\"5109\"]],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 18,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 19,
        ",\"5709\"]],AUTHORITY[\"EPSG\",\"7415\"]]");
    p = add_epsg_def_ex (filter, first, last, 7416, "epsg", 7416,
        "ETRS89 / UTM zone 32N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 32N + DVR90 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 32N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",9],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 11,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"25832\"]],VERT_CS[\"DVR90 height\",VE");
    add_srs_wkt (p, 15,
        "RT_DATUM[\"Dansk Vertikal Reference 1990\",2005,AUTHORIT");
    add_srs_wkt (p, 16,
        "Y[\"EPSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5799\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"7416\"]]");
    p = add_epsg_def_ex (filter, first, last, 7417, "epsg", 7417,
        "ETRS89 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 33N + DVR90 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 33N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",15],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 11,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"25833\"]],VERT_CS[\"DVR90 height\",V");
    add_srs_wkt (p, 15,
        "ERT_DATUM[\"Dansk Vertikal Reference 1990\",2005,AUTHORI");
    add_srs_wkt (p, 16,
        "TY[\"EPSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 17,
        "\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5799\"");
    add_srs_wkt (p, 18,
        "]],AUTHORITY[\"EPSG\",\"7417\"]]");
    p = add_epsg_def_ex (filter, first, last, 7418, "epsg", 7418,
        "ETRS89 / Kp2000 Jutland", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9.5 +k=0.99995 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vuni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / Kp2000 Jutland + DVR90 height\",PROJ");
    add_srs_wkt (p, 1,
        "CS[\"ETRS89 / Kp2000 Jutland\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 2,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 5,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 8,
        "T],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 9,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",9.5],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 11,
        "0.99995],PARAMETER[\"false_easting\",200000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"2196\"]],VERT_CS[\"DVR90 height\"");
    add_srs_wkt (p, 15,
        ",VERT_DATUM[\"Dansk Vertikal Reference 1990\",2005,AUTHO");
    add_srs_wkt (p, 16,
        "RITY[\"EPSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 17,
        "SG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"579");
    add_srs_wkt (p, 18,
        "9\"]],AUTHORITY[\"EPSG\",\"7418\"]]");
    p = add_epsg_def_ex (filter, first, last, 7419, "epsg", 7419,
        "ETRS89 / Kp2000 Zealand", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.99995 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / Kp2000 Zealand + DVR90 height\",PROJ");
    add_srs_wkt (p, 1,
        "CS[\"ETRS89 / Kp2000 Zealand\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 2,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 5,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 8,
        "T],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 9,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",12],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 11,
        ".99995],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"2197\"]],VERT_CS[\"DVR90 height\"");
    add_srs_wkt (p, 15,
        ",VERT_DATUM[\"Dansk Vertikal Reference 1990\",2005,AUTHO");
    add_srs_wkt (p, 16,
        "RITY[\"EPSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 17,
        "SG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"579");
    add_srs_wkt (p, 18,
        "9\"]],AUTHORITY[\"EPSG\",\"7419\"]]");
    p = add_epsg_def_ex (filter, first, last, 7420, "epsg", 7420,
        "ETRS89 / Kp2000 Bornholm", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=900000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / Kp2000 Bornholm + DVR90 height\",PRO");
    add_srs_wkt (p, 1,
        "JCS[\"ETRS89 / Kp2000 Bornholm\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 2,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 5,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 6,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 8,
        "EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 9,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 10,
        "METER[\"central_meridian\",15],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",1],PARAMETER[\"false_easting\",900000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"2198\"]],VERT_CS[\"DVR90 height\",VE");
    add_srs_wkt (p, 15,
        "RT_DATUM[\"Dansk Vertikal Reference 1990\",2005,AUTHORIT");
    add_srs_wkt (p, 16,
        "Y[\"EPSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5799\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"7420\"]]");
    p = add_epsg_def_ex (filter, first, last, 7421, "epsg", 7421,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone II + NGF-IGN69 hei");
    add_srs_wkt (p, 1,
        "ght\",PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 3,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 4,
        "212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60");
    add_srs_wkt (p, 5,
        ",320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Par");
    add_srs_wkt (p, 6,
        "is\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gra");
    add_srs_wkt (p, 7,
        "d\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AX");
    add_srs_wkt (p, 8,
        "IS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORIT");
    add_srs_wkt (p, 9,
        "Y[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 10,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 12,
        "987742],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 13,
        "false_northing\",2200000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"27572\"]],VERT_CS[\"NGF-IGN69 height\",");
    add_srs_wkt (p, 16,
        "VERT_DATUM[\"Nivellement General de la France - IGN69\",");
    add_srs_wkt (p, 17,
        "2005,AUTHORITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EP");
    add_srs_wkt (p, 19,
        "SG\",\"5720\"]],AUTHORITY[\"EPSG\",\"7421\"]]");
    p = add_epsg_def_ex (filter, first, last, 7422, "epsg", 7422,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone III + NGF-IGN69 he");
    add_srs_wkt (p, 1,
        "ight\",PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise");
    add_srs_wkt (p, 3,
        "_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46");
    add_srs_wkt (p, 4,
        "60212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-");
    add_srs_wkt (p, 5,
        "60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"P");
    add_srs_wkt (p, 6,
        "aris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"g");
    add_srs_wkt (p, 7,
        "rad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],");
    add_srs_wkt (p, 8,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 9,
        "ITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 10,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",49],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 12,
        "999877499],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 13,
        "[\"false_northing\",3200000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"27573\"]],VERT_CS[\"NGF-IGN69 height");
    add_srs_wkt (p, 16,
        "\",VERT_DATUM[\"Nivellement General de la France - IGN69");
    add_srs_wkt (p, 17,
        "\",2005,AUTHORITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 19,
        "EPSG\",\"5720\"]],AUTHORITY[\"EPSG\",\"7422\"]]");
    p = add_epsg_def_ex (filter, first, last, 7423, "epsg", 7423,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + EVRF2007 height\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],VERT_CS[\"EVRF");
    add_srs_wkt (p, 8,
        "2007 height\",VERT_DATUM[\"European Vertical Reference F");
    add_srs_wkt (p, 9,
        "rame 2007\",2005,AUTHORITY[\"EPSG\",\"5215\"]],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"5621\"]],AUTHORITY[\"EPSG\",\"7423\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20004, "epsg", 20004,
        "Pulkovo 1995 / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 4\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",21],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",4500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20004\"]]");
    p = add_epsg_def_ex (filter, first, last, 20005, "epsg", 20005,
        "Pulkovo 1995 / Gauss-Kruger zone 5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 5\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",27],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",5500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20005\"]]");
    p = add_epsg_def_ex (filter, first, last, 20006, "epsg", 20006,
        "Pulkovo 1995 / Gauss-Kruger zone 6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 6\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",33],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",6500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20006\"]]");
    p = add_epsg_def_ex (filter, first, last, 20007, "epsg", 20007,
        "Pulkovo 1995 / Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 7\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",7500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20007\"]]");
    p = add_epsg_def_ex (filter, first, last, 20008, "epsg", 20008,
        "Pulkovo 1995 / Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 8\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",8500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20008\"]]");
    p = add_epsg_def_ex (filter, first, last, 20009, "epsg", 20009,
        "Pulkovo 1995 / Gauss-Kruger zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 9\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",51],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",9500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20009\"]]");
    p = add_epsg_def_ex (filter, first, last, 20010, "epsg", 20010,
        "Pulkovo 1995 / Gauss-Kruger zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 10\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",57],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",10500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20010\"]]");
    p = add_epsg_def_ex (filter, first, last, 20011, "epsg", 20011,
        "Pulkovo 1995 / Gauss-Kruger zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 11\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",63],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",11500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20011\"]]");
    p = add_epsg_def_ex (filter, first, last, 20012, "epsg", 20012,
        "Pulkovo 1995 / Gauss-Kruger zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 12\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",69],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",12500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20012\"]]");
    p = add_epsg_def_ex (filter, first, last, 20013, "epsg", 20013,
        "Pulkovo 1995 / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",75],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",13500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20013\"]]");
    p = add_epsg_def_ex (filter, first, last, 20014, "epsg", 20014,
        "Pulkovo 1995 / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",81],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",14500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20014\"]]");
    p = add_epsg_def_ex (filter, first, last, 20015, "epsg", 20015,
        "Pulkovo 1995 / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",87],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",15500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20015\"]]");
    p = add_epsg_def_ex (filter, first, last, 20016, "epsg", 20016,
        "Pulkovo 1995 / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",93],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",16500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20016\"]]");
    p = add_epsg_def_ex (filter, first, last, 20017, "epsg", 20017,
        "Pulkovo 1995 / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",99],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",17500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20017\"]]");
    p = add_epsg_def_ex (filter, first, last, 20018, "epsg", 20018,
        "Pulkovo 1995 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",18500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20018\"]]");
    p = add_epsg_def_ex (filter, first, last, 20019, "epsg", 20019,
        "Pulkovo 1995 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",111],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",19500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20019\"]]");
    p = add_epsg_def_ex (filter, first, last, 20020, "epsg", 20020,
        "Pulkovo 1995 / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",117],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",20500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20020\"]]");
    p = add_epsg_def_ex (filter, first, last, 20021, "epsg", 20021,
        "Pulkovo 1995 / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",123],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",21500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20021\"]]");
    p = add_epsg_def_ex (filter, first, last, 20022, "epsg", 20022,
        "Pulkovo 1995 / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",129],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",22500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20022\"]]");
    p = add_epsg_def_ex (filter, first, last, 20023, "epsg", 20023,
        "Pulkovo 1995 / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",135],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",23500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20023\"]]");
    p = add_epsg_def_ex (filter, first, last, 20024, "epsg", 20024,
        "Pulkovo 1995 / Gauss-Kruger zone 24", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 24\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",141],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",24500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20024\"]]");
    p = add_epsg_def_ex (filter, first, last, 20025, "epsg", 20025,
        "Pulkovo 1995 / Gauss-Kruger zone 25", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 25\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",147],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",25500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20025\"]]");
    p = add_epsg_def_ex (filter, first, last, 20026, "epsg", 20026,
        "Pulkovo 1995 / Gauss-Kruger zone 26", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 26\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",153],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",26500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20026\"]]");
    p = add_epsg_def_ex (filter, first, last, 20027, "epsg", 20027,
        "Pulkovo 1995 / Gauss-Kruger zone 27", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 27\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",159],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",27500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20027\"]]");
    p = add_epsg_def_ex (filter, first, last, 20028, "epsg", 20028,
        "Pulkovo 1995 / Gauss-Kruger zone 28", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 28\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",165],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",28500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20028\"]]");
    p = add_epsg_def_ex (filter, first, last, 20029, "epsg", 20029,
        "Pulkovo 1995 / Gauss-Kruger zone 29", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",171],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",29500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20029\"]]");
    p = add_epsg_def_ex (filter, first, last, 20030, "epsg", 20030,
        "Pulkovo 1995 / Gauss-Kruger zone 30", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 30\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",177],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",30500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20030\"]]");
    p = add_epsg_def_ex (filter, first, last, 20031, "epsg", 20031,
        "Pulkovo 1995 / Gauss-Kruger zone 31", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-");
    add_proj4text (p, 2,
        "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 31\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",-177],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",31500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20031\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

