% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markDuplicates.R
\name{picardMarkDuplicates}
\alias{picardMarkDuplicates}
\title{Mark duplicates using Picard tools}
\usage{
picardMarkDuplicates(bam, out, path, verbose, threads = 1, maxmem = "4g")
}
\arguments{
\item{bam}{The bam file to mark duplicates from}

\item{out}{Regular expression describing the transformation on the original
filename to get the output filename. By default, a "_duprm" suffix is
added before the bam extension}

\item{path}{Path to the duplicate marker binaries}

\item{verbose}{Redirect all the program output to the R console}

\item{threads}{Number of threads to use}

\item{maxmem}{Max memory assigned to the jvm}
}
\value{
The return code of the system call
}
\description{
\code{picardMarkDuplicates} Mark duplicated reads from a BAM file by calling
  picard tools
}
\details{
This function is supposed to be called through the \code{markDuplicates}
  wrapper
}
