// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 4
// REQUIRES: aarch64-registered-target

// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +bf16 -target-feature +sme -target-feature +sme2 -target-feature +sme2p1 -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -p mem2reg,instcombine,tailcallelim | FileCheck %s
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +bf16 -target-feature +sme -target-feature +sme2 -target-feature +sme2p1 -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -p mem2reg,instcombine,tailcallelim | FileCheck %s -check-prefix=CPP-CHECK
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +bf16 -target-feature +sme -target-feature +sme2 -target-feature +sme2p1 -disable-O0-optnone -Werror -Wall -o /dev/null %s

#include <arm_sme.h>

#define SVE_ACLE_FUNC(A1,A2) A1##A2

// CHECK-LABEL: define dso_local void @test_svzero_za64_vg1x2(
// CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg1x2(i32 [[SLICE]])
// CHECK-NEXT:    ret void
//
// CPP-CHECK-LABEL: define dso_local void @_Z22test_svzero_za64_vg1x2j(
// CPP-CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0:[0-9]+]] {
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg1x2(i32 [[SLICE]])
// CPP-CHECK-NEXT:    ret void
//
void test_svzero_za64_vg1x2(uint32_t slice) __arm_streaming __arm_inout("za")
{
   SVE_ACLE_FUNC(svzero_za64,_vg1x2)(slice);
}

// CHECK-LABEL: define dso_local void @test_svzero_za64_vg1x4(
// CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg1x4(i32 [[SLICE]])
// CHECK-NEXT:    ret void
//
// CPP-CHECK-LABEL: define dso_local void @_Z22test_svzero_za64_vg1x4j(
// CPP-CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg1x4(i32 [[SLICE]])
// CPP-CHECK-NEXT:    ret void
//
void test_svzero_za64_vg1x4(uint32_t slice) __arm_streaming __arm_inout("za"){
   SVE_ACLE_FUNC(svzero_za64,_vg1x4)(slice);
}

// CHECK-LABEL: define dso_local void @test_svzero_za64_vg2x1(
// CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg2x1(i32 [[SLICE]])
// CHECK-NEXT:    ret void
//
// CPP-CHECK-LABEL: define dso_local void @_Z22test_svzero_za64_vg2x1j(
// CPP-CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg2x1(i32 [[SLICE]])
// CPP-CHECK-NEXT:    ret void
//
void test_svzero_za64_vg2x1(uint32_t slice) __arm_streaming __arm_inout("za"){
   SVE_ACLE_FUNC(svzero_za64,_vg2x1)(slice);
}

// CHECK-LABEL: define dso_local void @test_svzero_za64_vg2x2(
// CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg2x2(i32 [[SLICE]])
// CHECK-NEXT:    ret void
//
// CPP-CHECK-LABEL: define dso_local void @_Z22test_svzero_za64_vg2x2j(
// CPP-CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg2x2(i32 [[SLICE]])
// CPP-CHECK-NEXT:    ret void
//
void test_svzero_za64_vg2x2(uint32_t slice) __arm_streaming __arm_inout("za"){
   SVE_ACLE_FUNC(svzero_za64,_vg2x2)(slice);
}

// CHECK-LABEL: define dso_local void @test_svzero_za64_vg2x4(
// CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg2x4(i32 [[SLICE]])
// CHECK-NEXT:    ret void
//
// CPP-CHECK-LABEL: define dso_local void @_Z22test_svzero_za64_vg2x4j(
// CPP-CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg2x4(i32 [[SLICE]])
// CPP-CHECK-NEXT:    ret void
//
void test_svzero_za64_vg2x4(uint32_t slice)  __arm_streaming __arm_inout("za"){
   SVE_ACLE_FUNC(svzero_za64,_vg2x4)(slice);
}

// CHECK-LABEL: define dso_local void @test_svzero_za64_vg4x1(
// CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg4x1(i32 [[SLICE]])
// CHECK-NEXT:    ret void
//
// CPP-CHECK-LABEL: define dso_local void @_Z22test_svzero_za64_vg4x1j(
// CPP-CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg4x1(i32 [[SLICE]])
// CPP-CHECK-NEXT:    ret void
//
void test_svzero_za64_vg4x1(uint32_t slice) __arm_streaming __arm_inout("za"){
   SVE_ACLE_FUNC(svzero_za64,_vg4x1)(slice);
}

// CHECK-LABEL: define dso_local void @test_svzero_za64_vg4x2(
// CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg4x2(i32 [[SLICE]])
// CHECK-NEXT:    ret void
//
// CPP-CHECK-LABEL: define dso_local void @_Z22test_svzero_za64_vg4x2j(
// CPP-CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg4x2(i32 [[SLICE]])
// CPP-CHECK-NEXT:    ret void
//
void test_svzero_za64_vg4x2(uint32_t slice) __arm_streaming __arm_inout("za"){
   SVE_ACLE_FUNC(svzero_za64,_vg4x2)(slice);
}

// CHECK-LABEL: define dso_local void @test_svzero_za64_vg4x4(
// CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg4x4(i32 [[SLICE]])
// CHECK-NEXT:    ret void
//
// CPP-CHECK-LABEL: define dso_local void @_Z22test_svzero_za64_vg4x4j(
// CPP-CHECK-SAME: i32 noundef [[SLICE:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    tail call void @llvm.aarch64.sme.zero.za64.vg4x4(i32 [[SLICE]])
// CPP-CHECK-NEXT:    ret void
//
void test_svzero_za64_vg4x4(uint32_t slice) __arm_streaming __arm_inout("za"){
   SVE_ACLE_FUNC(svzero_za64,_vg4x4)(slice);
}
