set(ECM_MODULE_DIR "${CMAKE_CURRENT_SOURCE_DIR}/../../../modules")
set(CMAKE_MODULE_PATH "${ECM_MODULE_DIR}")

set(CMAKE_INSTALL_PREFIX "/usr")

function (compare_files)
    set(options)
    set(oneValueArgs GENERATED ORIGINALS)
    set(multiValueArgs)
    cmake_parse_arguments(CF "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})
    list(LENGTH CF_GENERATED count)
    math(EXPR last "${count}-1")
    foreach(i RANGE ${last})
        list(GET CF_GENERATED ${i} generated_file)
        if (NOT EXISTS "${generated_file}")
            message(FATAL_ERROR "${generated_file} was not generated")
        endif()
        file(READ "${generated_file}" file_contents)
        string(STRIP "${file_contents}" file_contents)

        list(GET CF_ORIGINALS ${i} original_file)
        if (NOT EXISTS "${original_file}")
            message(FATAL_ERROR "Original ${original_file} was not found")
        endif()
        file(READ "${original_file}" original_contents)
        string(STRIP "${original_contents}" original_contents)

        if(NOT original_contents STREQUAL file_contents)
            message(FATAL_ERROR "Different files: ${original_file} ${generated_file}")
        endif()
    endforeach()
endfunction()
