#![cfg(feature = "std")]

use std::iter::FromIterator;

use tabled::{builder::Builder, settings::split::Split, Table};

use testing_table::test_table;

test_table!(
    split_column_test,
    Table::from_iter(['a'..='z']).with(Split::column(12)),
    "+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| a | b | c | d | e | f | g | h | i | j | k | l |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| m | n | o | p | q | r | s | t | u | v | w | x |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| y | z |   |   |   |   |   |   |   |   |   |   |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+"
);

test_table!(
    split_column_2_test,
    Table::from_iter(['a'..='z'])
        .with(Split::column(12))
        .with(Split::column(4)),
    "+---+---+---+---+"
    "| a | b | c | d |"
    "+---+---+---+---+"
    "| e | f | g | h |"
    "+---+---+---+---+"
    "| i | j | k | l |"
    "+---+---+---+---+"
    "| m | n | o | p |"
    "+---+---+---+---+"
    "| q | r | s | t |"
    "+---+---+---+---+"
    "| u | v | w | x |"
    "+---+---+---+---+"
    "| y | z |   |   |"
    "+---+---+---+---+"
);

test_table!(
    split_column_retain_test,
    Table::from_iter(['a'..='z'])
        .with(Split::column(12))
        .with(Split::column(4).retain()),
    "+---+---+---+---+"
    "| a | b | c | d |"
    "+---+---+---+---+"
    "| e | f | g | h |"
    "+---+---+---+---+"
    "| i | j | k | l |"
    "+---+---+---+---+"
    "| m | n | o | p |"
    "+---+---+---+---+"
    "| q | r | s | t |"
    "+---+---+---+---+"
    "| u | v | w | x |"
    "+---+---+---+---+"
    "| y | z |   |   |"
    "+---+---+---+---+"
    "|   |   |   |   |"
    "+---+---+---+---+"
    "|   |   |   |   |"
    "+---+---+---+---+"
);

test_table!(
    split_row_test,
    Table::from_iter(['a'..='z'])
        .with(Split::column(12))
        .with(Split::column(4))
        .with(Split::row(1).concat()), // take it back to the original shape
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| a | b | c | d | e | f | g | h | i | j | k | l | m | n | o | p | q | r | s | t | u | v | w | x | y | z |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
);

test_table!(
    split_row_2_test,
    Table::from_iter(['a'..='z'])
        .with(Split::column(12))
        .with(Split::column(4))
        .with(Split::row(2).concat()),
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| a | b | c | d | i | j | k | l | q | r | s | t | y | z |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| e | f | g | h | m | n | o | p | u | v | w | x |   |   |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
);

test_table!(
    split_colum_index_beyond_size_test,
    Table::from_iter(['a'..='z'])
        .with(Split::column(10000)),
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| a | b | c | d | e | f | g | h | i | j | k | l | m | n | o | p | q | r | s | t | u | v | w | x | y | z |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
);

test_table!(
    split_row_index_beyond_size_test,
    Table::from_iter(['a'..='z'])
        .with(Split::row(10000)),
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| a | b | c | d | e | f | g | h | i | j | k | l | m | n | o | p | q | r | s | t | u | v | w | x | y | z |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
);

test_table!(
    split_empty_table_test,
    Builder::default().build().with(Split::column(10000)),
    ""
);

test_table!(
    split_column_zero_argument_test,
    Table::from_iter(['a'..='z']).with(Split::column(0)),
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| a | b | c | d | e | f | g | h | i | j | k | l | m | n | o | p | q | r | s | t | u | v | w | x | y | z |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
);

test_table!(
    split_row_zero_argument_test,
    Table::from_iter(['a'..='z']).with(Split::row(0)),
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| a | b | c | d | e | f | g | h | i | j | k | l | m | n | o | p | q | r | s | t | u | v | w | x | y | z |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
);

test_table!(
    split_blank_table_test,
    Table::from_iter([vec![String::new(); 26]]).with(Split::column(12)),
    "+--+--+--+--+--+--+--+--+--+--+--+--+"
    "|  |  |  |  |  |  |  |  |  |  |  |  |" // first section is protected
    "+--+--+--+--+--+--+--+--+--+--+--+--+"
);

test_table!(
    split_blank_table_2_test,
    Table::from_iter([vec![String::new(); 26]]).with(Split::column(12).retain()),
    "+--+--+--+--+--+--+--+--+--+--+--+--+"
    "|  |  |  |  |  |  |  |  |  |  |  |  |"
    "+--+--+--+--+--+--+--+--+--+--+--+--+"
    "|  |  |  |  |  |  |  |  |  |  |  |  |"
    "+--+--+--+--+--+--+--+--+--+--+--+--+"
    "|  |  |  |  |  |  |  |  |  |  |  |  |"
    "+--+--+--+--+--+--+--+--+--+--+--+--+"
);

test_table!(
    split_zip_test,
    Table::from_iter(['a'..='z'])
        .with(Split::column(6))
        .with(Split::row(2)),
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| a | m | y | b | n | z | c | o | d | p | e | q | f | r |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| g | s |   | h | t |   | i | u | j | v | k | w | l | x |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
);

test_table!(
    split_concat_test,
    Table::from_iter(['a'..='z'])
        .with(Split::column(6))
        .with(Split::row(2).concat()),
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| a | b | c | d | e | f | m | n | o | p | q | r | y | z |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| g | h | i | j | k | l | s | t | u | v | w | x |   |   |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
);

test_table!(
    split_clean_test,
    Table::from_iter(['a'..='z'])
        .with(Split::column(12))
        .with(Split::row(2)),
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| a | y | b | z | c | d | e | f | g | h | i | j | k | l |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
    "| m |   | n |   | o | p | q | r | s | t | u | v | w | x |"
    "+---+---+---+---+---+---+---+---+---+---+---+---+---+---+"
);

test_table!(
    split_retain_test,
    Table::from_iter(['a'..='z'])
        .with(Split::column(12))
        .with(Split::row(2).retain()),
    "+---+---+---+---+---+--+---+--+---+--+---+--+---+--+---+--+---+--+---+--+---+--+---+--+"
    "| a | y | b | z | c |  | d |  | e |  | f |  | g |  | h |  | i |  | j |  | k |  | l |  |"
    "+---+---+---+---+---+--+---+--+---+--+---+--+---+--+---+--+---+--+---+--+---+--+---+--+"
    "| m |   | n |   | o |  | p |  | q |  | r |  | s |  | t |  | u |  | v |  | w |  | x |  |"
    "+---+---+---+---+---+--+---+--+---+--+---+--+---+--+---+--+---+--+---+--+---+--+---+--+"
);

test_table!(
    split_mostly_blank_test,
    Table::from_iter([vec![
        "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
        "", "", "", "", "", "", "", "", "", "", "A",
    ]]).with(Split::column(5))
       .with(Split::row(2)),
    "+--+--+--+---+--+"
    "|  |  |  |   |  |"
    "+--+--+--+---+--+"
    "|  |  |  | A |  |"
    "+--+--+--+---+--+"
);

test_table!(
    split_mostly_blank_retain_test,
    Table::from_iter([vec![
        "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
        "", "", "", "", "", "", "", "", "", "", "A",
    ]]).with(Split::column(5).retain()),
    "+--+--+--+---+--+"
    "|  |  |  |   |  |"
    "+--+--+--+---+--+"
    "|  |  |  |   |  |"
    "+--+--+--+---+--+"
    "|  |  |  |   |  |"
    "+--+--+--+---+--+"
    "|  |  |  |   |  |"
    "+--+--+--+---+--+"
    "|  |  |  |   |  |"
    "+--+--+--+---+--+"
    "|  |  |  |   |  |"
    "+--+--+--+---+--+"
    "|  |  |  | A |  |"
    "+--+--+--+---+--+"
);

test_table!(
    split_scattered_values_test,
    Table::from_iter([vec![
        "", "", "", "", "", "g", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
        "", "", "", "", "", "", "", "", "", "", "A",
    ]]).with(Split::column(5)),
    "+---+--+--+---+--+"
    "|   |  |  |   |  |"
    "+---+--+--+---+--+"
    "| g |  |  |   |  |"
    "+---+--+--+---+--+"
    "|   |  |  | A |  |"
    "+---+--+--+---+--+"
);

test_table!(
    split_scattered_values_column_and_row_test,
    Table::from_iter([vec![
        "", "", "", "", "", "g", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
        "", "", "", "", "", "", "", "", "", "", "A",
    ]]).with(Split::column(5)).with(Split::row(2)),
    "+---+--+--+--+---+--+"
    "|   |  |  |  | A |  |"
    "+---+--+--+--+---+--+"
    "| g |  |  |  |   |  |"
    "+---+--+--+--+---+--+"
);

test_table!(
    split_scattered_values_column_and_row_retain_test,
    Table::from_iter([vec![
        "", "", "", "", "", "g", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
        "", "", "", "", "", "", "", "", "", "", "A",
    ]]).with(Split::column(5).retain()).with(Split::row(2).retain()),
    "+---+--+--+--+--+--+--+--+--+--+--+--+--+--+--+---+--+--+--+--+"
    "|   |  |  |  |  |  |  |  |  |  |  |  |  |  |  | A |  |  |  |  |"
    "+---+--+--+--+--+--+--+--+--+--+--+--+--+--+--+---+--+--+--+--+"
    "| g |  |  |  |  |  |  |  |  |  |  |  |  |  |  |   |  |  |  |  |"
    "+---+--+--+--+--+--+--+--+--+--+--+--+--+--+--+---+--+--+--+--+"
);
